#include "utils.hpp"

std::string loadFile(const std::string& path) { //Loads raw file data from path
    std::ifstream file(path);
    std::stringstream buf;
    buf << file.rdbuf();
    return buf.str();
}

void logVec3(glm::vec3 P){ //For debugging purposes.
	std::cout << P.x << " | " << P.y << " | " << P.z <<"\n";
}

std::string webGLtoOpenGL(const std::string& raw){ //Adds the missing version indicator.
	return "#version 330 core\n"+raw;
}

GLuint loadTexture(const char* path, int& width, int& height) { //Load using stb_image
	int channels;
	
    stbi_set_flip_vertically_on_load(false); //Because OpenGL has some bullshit, flipping is needed for non-flipped look.
	
    unsigned char* data = stbi_load(path, &width, &height, &channels, 0); //Load image, extract channels, width and height
    if (!data) { //Check is data loading successful.
        std::cerr << "Failed to load texture: " << path << std::endl;
        return 0;
    }

    GLuint tex; //Make texture
    glGenTextures(1, &tex); //Generate texture to tex.
    glBindTexture(GL_TEXTURE_2D, tex); //Bind a 2D texture to tex.
    GLenum format = (channels == 4) ? GL_RGBA : GL_RGB; //Based on channels, set the format.
    glTexImage2D(GL_TEXTURE_2D, 0, format, width, height, 0, format, GL_UNSIGNED_BYTE, data); //Place the texture width extracted data.
    glGenerateMipmap(GL_TEXTURE_2D); //Generate mipmaps for tex.

    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT); //Set repeating horizontally and vertically -V
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT); // =||=
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR); //Setting mipmap linear filter
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); //Set linear max filter.

    stbi_image_free(data); //Free imported image "data". Texture is already imported.
    return tex;
}