#ifndef MENU_ELEMENTS_HPP
#define MENU_ELEMENTS_HPP

#include "imgui.h"
#include "imgui_impl_glfw.h"
#include "imgui_impl_opengl3.h"
#include <stdio.h>
#define GL_SILENCE_DEPRECATION
#if defined(IMGUI_IMPL_OPENGL_ES2)
#include <GLES2/gl2.h>
#endif
#include <GLFW/glfw3.h> // Will drag system OpenGL headers
#include <ctime>
#include <cstdlib>
#include <string>

#include "../render_helpers.hpp"

template<typename Derived>
class RenderWindow{
	private:
		GLFWwindow* window = nullptr;
		
	
	protected:
		ImVec4 clear_color = ImVec4(0.45f, 0.55f, 0.60f, 1.00f);
		//ImGuiIO io;
		
		bool aborted = false;
		
		const char* window_title;
		int window_width =-1;
		int window_height = -1;
		
		ImGuiIO* io = nullptr;
		
	public:
	
		
		int getWidth() const {
			int w;
			int h;
			glfwGetWindowSize(window, &w, &h);
			return w;
		}

		int getHeight() const {
			int w;
			int h;
			glfwGetWindowSize(window, &w, &h);
			return h;
		}
		
		int getFramebufferWidth() const {
			int w;
			int h;
			glfwGetFramebufferSize(window, &w, &h);
			return w;
		}

		int getFramebufferHeight() const {
			int w;
			int h;
			glfwGetFramebufferSize(window, &w, &h);
			return h;
		}
		
		GLFWwindow* getWindow() const{
			return window;
		}
		
		void set_background_color(ImVec4 c){
			clear_color = c;
		}
		RenderWindow(int _window_width, int _window_height, const char* _window_title){
			window_title = _window_title;
			
			window_width = _window_width;
			
			window_height = _window_height;
			
			if(window_width <= 0 || window_height <=0){
				aborted=true;
				return;
			}
			
			glfwSetErrorCallback(glfw_error_callback);
			if (!glfwInit()){
				aborted = true;
				return;
			}

			// Decide GL+GLSL versions
		#if defined(IMGUI_IMPL_OPENGL_ES2)
			// GL ES 2.0 + GLSL 100 (WebGL 1.0)
			const char* glsl_version = "#version 100";
			glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 2);
			glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 0);
			glfwWindowHint(GLFW_CLIENT_API, GLFW_OPENGL_ES_API);
		#elif defined(IMGUI_IMPL_OPENGL_ES3)
			// GL ES 3.0 + GLSL 300 es (WebGL 2.0)
			const char* glsl_version = "#version 300 es";
			glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
			glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 0);
			glfwWindowHint(GLFW_CLIENT_API, GLFW_OPENGL_ES_API);
		#elif defined(__APPLE__)
			// GL 3.2 + GLSL 150
			const char* glsl_version = "#version 150";
			glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
			glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 2);
			glfwWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE);  // 3.2+ only
			glfwWindowHint(GLFW_OPENGL_FORWARD_COMPAT, GL_TRUE);            // Required on Mac
		#else
			// GL 3.0 + GLSL 130
			const char* glsl_version = "#version 130";
			glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
			glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 0);
			//glfwWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE);  // 3.2+ only
			//glfwWindowHint(GLFW_OPENGL_FORWARD_COMPAT, GL_TRUE);            // 3.0+ only
		#endif

			// Create window with graphics context
			float main_scale = ImGui_ImplGlfw_GetContentScaleForMonitor(glfwGetPrimaryMonitor()); // Valid on GLFW 3.3+ only
			window = glfwCreateWindow((int)(window_width * main_scale), (int)(window_height * main_scale), window_title, nullptr, nullptr);
			if (window == nullptr){
				aborted = true;
				return;
			}
			glfwMakeContextCurrent(window);
			glfwSwapInterval(1); // Enable vsync

			// Setup Dear ImGui context
			IMGUI_CHECKVERSION();
			ImGui::CreateContext();
			//io = ImGui::GetIO();
			io = &ImGui::GetIO();
			io->ConfigFlags |= ImGuiConfigFlags_NavEnableKeyboard;     // Enable Keyboard Controls
			io->ConfigFlags |= ImGuiConfigFlags_NavEnableGamepad;      // Enable Gamepad Controls

			// Setup Dear ImGui style
			ImGui::StyleColorsDark();
			//ImGui::StyleColorsLight();

			// Setup scaling
			ImGuiStyle& style = ImGui::GetStyle();
			style.ScaleAllSizes(main_scale);        // Bake a fixed style scale. (until we have a solution for dynamic style scaling, changing this requires resetting Style + calling this again)
			style.FontScaleDpi = main_scale;        // Set initial font scale. (using io.ConfigDpiScaleFonts=true makes this unnecessary. We leave both here for documentation purpose)

			// Setup Platform/Renderer backends
			ImGui_ImplGlfw_InitForOpenGL(window, true);
		#ifdef __EMSCRIPTEN__
			ImGui_ImplGlfw_InstallEmscriptenCallbacks(window, "#canvas");
		#endif
			ImGui_ImplOpenGL3_Init(glsl_version);

			// Load Fonts
			// - If fonts are not explicitly loaded, Dear ImGui will call AddFontDefault() to select an embedded font: either AddFontDefaultVector() or AddFontDefaultBitmap().
			//   This selection is based on (style.FontSizeBase * style.FontScaleMain * style.FontScaleDpi) reaching a small threshold.
			// - You can load multiple fonts and use ImGui::PushFont()/PopFont() to select them.
			// - If a file cannot be loaded, AddFont functions will return a nullptr. Please handle those errors in your code (e.g. use an assertion, display an error and quit).
			// - Read 'docs/FONTS.md' for more instructions and details.
			// - Use '#define IMGUI_ENABLE_FREETYPE' in your imconfig file to use FreeType for higher quality font rendering.
			// - Remember that in C/C++ if you want to include a backslash \ in a string literal you need to write a double backslash \\ !
			// - Our Emscripten build process allows embedding fonts to be accessible at runtime from the "fonts/" folder. See Makefile.emscripten for details.
			//style.FontSizeBase = 20.0f;
			//io.Fonts->AddFontDefaultVector();
			//io.Fonts->AddFontDefaultBitmap();
			//io.Fonts->AddFontFromFileTTF("c:\\Windows\\Fonts\\segoeui.ttf");
			//io.Fonts->AddFontFromFileTTF("../../misc/fonts/DroidSans.ttf");
			//io.Fonts->AddFontFromFileTTF("../../misc/fonts/Roboto-Medium.ttf");
			//io.Fonts->AddFontFromFileTTF("../../misc/fonts/Cousine-Regular.ttf");
			//ImFont* font = io.Fonts->AddFontFromFileTTF("c:\\Windows\\Fonts\\ArialUni.ttf");
			//IM_ASSERT(font != nullptr);
		}
		~RenderWindow(){
			// Cleanup
			ImGui_ImplOpenGL3_Shutdown();
			ImGui_ImplGlfw_Shutdown();
			ImGui::DestroyContext();

			glfwDestroyWindow(window);
			glfwTerminate();
		}
		
		void init(){
			static_cast<Derived*>(this)->init();
		}

		void tick(){
			static_cast<Derived*>(this)->tick();
		}
		
		void run(){
			static_cast<Derived*>(this)->init();
			
			#ifdef __EMSCRIPTEN__
				// For an Emscripten build we are disabling file-system access, so let's not attempt to do a fopen() of the imgui.ini file.
				// You may manually call LoadIniSettingsFromMemory() to load settings from your own storage.
				io->IniFilename = nullptr;
				EMSCRIPTEN_MAINLOOP_BEGIN
			#else
				while (!glfwWindowShouldClose(window) && aborted == false){
			#endif
				// Poll and handle events (inputs, window resize, etc.)
				// You can read the io.WantCaptureMouse, io.WantCaptureKeyboard flags to tell if dear imgui wants to use your inputs.
				// - When io.WantCaptureMouse is true, do not dispatch mouse input data to your main application, or clear/overwrite your copy of the mouse data.
				// - When io.WantCaptureKeyboard is true, do not dispatch keyboard input data to your main application, or clear/overwrite your copy of the keyboard data.
				// Generally you may always pass all inputs to dear imgui, and hide them from your application based on those two flags.
				glfwPollEvents();
				if (glfwGetWindowAttrib(window, GLFW_ICONIFIED) != 0)
				{
					ImGui_ImplGlfw_Sleep(10);
					continue;
				}

				// Start the Dear ImGui frame
				ImGui_ImplOpenGL3_NewFrame();
				ImGui_ImplGlfw_NewFrame();
				ImGui::NewFrame();
		
				static_cast<Derived*>(this)->tick();
				
				// Rendering
				ImGui::Render();
				int display_w, display_h;
				glfwGetFramebufferSize(window, &display_w, &display_h);
				glViewport(0, 0, display_w, display_h);
				glClearColor(clear_color.x * clear_color.w, clear_color.y * clear_color.w, clear_color.z * clear_color.w, clear_color.w);
				glClear(GL_COLOR_BUFFER_BIT);
				ImGui_ImplOpenGL3_RenderDrawData(ImGui::GetDrawData());

				glfwSwapBuffers(window);
			}
			#ifdef __EMSCRIPTEN__
				EMSCRIPTEN_MAINLOOP_END;
			#endif
		}
};

#endif