#ifndef LOGICAL_PAGE_HPP
#define LOGICAL_PAGE_HPP

#include "../control_data.hpp"
#include "menu_elements.hpp"

#include "../utils.hpp"
#include "../input_state.hpp"

#include "misc/cpp/imgui_stdlib.h"

#include "../file_io/electronic_module_saving.hpp"

#include <iostream>

class LogicalPage{
	protected:
		
		std::vector<ImTextureID> componentTextures;
		
		ElectricalComponentCollection mainCollection;
		
		ElectricalComponentCollection sceneSaveable;
		
		ControlData* d = nullptr;
	public:
		ElectricalNodeCollection electronics;
		
		CustomElectricalComponent* selectedElectrical = nullptr;
	
		GeneralSimulation* sim = nullptr;
		
		virtual ~LogicalPage();
		
		void setControlData(ControlData* _d);
		
		void preInit();
		
		virtual void initialize()= 0;
		
		virtual void loadTextureForComponent(const char* filepath) = 0;
		
		void loadTexturesFromMainCollection();
		
		virtual void drawGUI(ImVec4& clear_color,float frate) = 0;
		
		virtual void handleInteractions() =0;
};

#endif