#include "digital_menu.hpp"
	
DigitalPage::DigitalPage(){
	
}

void DigitalPage::initialize(){
	
	
	sim = new DigitalSimulation();
	
	electronics.setRelImagePath(GRAPHICS_DIGITAL_PATH);
	electronics.simulation = sim;
	
	mainCollection.loadDefaultsDigital();
}

void DigitalPage::loadTextureForComponent(const char* filepath) {
	std::string fullPath = std::string(GRAPHICS_PATH) + GRAPHICS_DIGITAL_PATH + filepath;
	
	
	int TtextureWidth;
	int TtextureHeight;
	GLuint opengl_texture = loadTexture(fullPath.c_str(),TtextureWidth,TtextureHeight);
	ImTextureID tex_id = (ImTextureID)opengl_texture;
	componentTextures.emplace_back(tex_id);
}

void DigitalPage::drawGUI(ImVec4& clear_color,float frate){
	if(d == nullptr){
		return;
	}
	
	{
		//static float f = 0.0f;
		//static int counter = 0;
		ImGui::SetNextWindowPos(ImVec2(0, 0));
		ImGui::Begin("Digital schematic designer",nullptr,ImGuiWindowFlags_AlwaysAutoResize);

		ImGui::Text("Click to the tools to select them, drag or drop elements.");
		ImGui::Separator();
		ImGui::Text("Information:");
		ImGui::Checkbox("Show schematic overlay stats", &d->show_overlay_text);
		
		if(ImGui::Checkbox("Snap to grid", &d->snap_to_grid)){
			if(d->snap_to_grid == true){
				InputState::getInstance()->snap_grid_size = d->cell_size;
			} else {
				InputState::getInstance()->snap_grid_size = 1;
			}
		}
		if (ImGui::Button("Show components")){
			show_comp_window = true;
		}
		ImGui::Separator();
		ImGui::Text("Vanity tools:");
		
		

		ImGui::ColorEdit3("clear color", (float*)&clear_color);
		ImGui::Separator();
		ImGui::Text("Simulation tools:");

		if (ImGui::Button("Validate!")){
			electronics.simulation->validate();
			d->show_validated = true;
		}
		if (ImGui::Button("Solve!")){
			electronics.solve();
		}
		ImGui::Separator();
		ImGui::Text("General tools:");
		
		if (ImGui::Button("Invert input bits")) {
			d->selectedToolId =4;
		}
		ImGui::Separator();
		
		if (ImGui::Button("Set rotation")) {
			d->selectedToolId =3;
		}
		ImGui::InputDouble("Rotation (DEG)", &d->rotationValue, 0.0, 360.0);
		
		ImGui::Separator();
		if (ImGui::Button("Select tool")) {
			d->selectedToolId =0;
			InputState::getInstance()->dragMode = false;
		}
		ImGui::SameLine();
		ImGui::Text("(Selected pieces can be deleted)");
		
		ImGui::Separator();
		if (ImGui::Button("Connect wires")) {
			d->selectedToolId =2;
			
			d->phasesWiring=0;
			d->forWire1 = nullptr;
			d->forWire2 = nullptr;
			d->p1 = nullptr;
			d->p2 = nullptr;
			InputState::getInstance()->dragged2DElement = nullptr;
			InputState::getInstance()->dragMode = false;
		}

		ImGui::Separator();
		if (ImGui::Button("Move tool")) {
			InputState::getInstance()->dragMode = true;
			d->selectedToolId =0;
		}
		ImGui::Separator();
		ImGui::Text("Place / move basic components");
		ImGui::PushStyleColor(ImGuiCol_ChildBg, clear_color);
		ImGui::BeginChild("Place / move basic components", ImVec2(0, 100), true);
			
			for(size_t i=0;i<mainCollection.components.size();i++){
				if (ImGui::Button(mainCollection.components[i]->importedName.c_str())) {
					selectedElectrical = mainCollection.components[i];
					d->selectedToolId = 1;
				}
				if (ImGui::IsItemHovered()){
					
					std::string hoverLabel = std::string("Switch to: ")+mainCollection.components[i]->importedName;
					
					ImGui::SetTooltip("%s",hoverLabel.c_str());
				}
				
				ImGui::SameLine();
				ImGui::Image(componentTextures[i], ImVec2(32,32));
				ImGui::Separator();
			}
			
		ImGui::EndChild();
		ImGui::PopStyleColor();
		ImGui::Separator();
		ImGui::Text("Save / load or export:");
		
		static std::string save_name;
		if (ImGui::Button("Save to:")) {
			sceneSaveable.saveTo(save_name+DCF_FILE_EXTENSION);
			
		}
		ImGui::InputText("Save location", &save_name);
		ImGui::Separator();
		static std::string load_name;
		
		if (ImGui::Button("Load from:")) {
			sceneSaveable.loadFrom(load_name+DCF_FILE_EXTENSION);
			
			sceneSaveable.seedTo(electronics);
		}
		ImGui::InputText("Load location", &load_name);
		ImGui::Separator();

		ImGui::Text("Application average %.3f ms/frame (%.1f FPS)", 1000.0f / frate, frate);
		ImGui::End();
	}

	if (show_comp_window){
		ImGui::SetNextWindowFocus();
		ImGui::Begin("Digital schematic components", &show_comp_window,ImGuiWindowFlags_AlwaysAutoResize);
		
		std::string totalList = "\nNets:\n";
		for(size_t i=0;i<sim->netAmount();i++){
			totalList+= sim->getNet(i)->getName() +": Voltage:" + std::to_string(sim->getNet(i)->voltage)+"V ("+std::to_string(i)+")\n";
		}
		
		totalList+= "\nComponents:\n";
		for(size_t i=0;i<sim->componentAmount();i++){
			totalList+= sim->getComponent(i)->getName() +" ("+std::to_string(i)+")\n";
		}
	
		ImGui::Text("Components, wires and nets: %s",totalList.c_str());
		if (ImGui::Button("Close")){
			show_comp_window = false;
		}
		ImGui::End();
	}
	
	if (d->show_validated){
		ImGui::SetNextWindowFocus();
		ImGui::Begin("Validator messages", &d->show_validated,ImGuiWindowFlags_AlwaysAutoResize);
	
		ImGui::Text("%s",sim->validatedText.c_str());
		if (ImGui::Button("Close")){
			d->show_validated = false;
		}
		ImGui::End();
	}
	
	
	
	if(InputState::getInstance()->dragMode == false &&InputState::getInstance()->dragging == true && InputState::getInstance()->dragged2DElement){
		ImGui::SetNextWindowFocus();
		ImGui::Begin("Selected component",nullptr,ImGuiWindowFlags_AlwaysAutoResize);
		
		if (ImGui::Button("Delete component")){
			InputState::getInstance()->dragging = false;
			electronics.checkDelete(InputState::getInstance()->dragged2DElement);
			InputState::getInstance()->dragged2DElement = nullptr;
		}
		if (ImGui::Button("Deselect")){
			InputState::getInstance()->dragging = false;
			InputState::getInstance()->dragged2DElement = nullptr;
		}
		ImGui::End();
	}
}

void DigitalPage::handleInteractions() {
	if (!ImGui::IsWindowHovered(ImGuiHoveredFlags_AnyWindow) && !ImGui::IsAnyItemHovered()){
		switch(d->selectedToolId){
			case 0: //ZOOM / PAN
				if(d->screen_updated == true){
					electronics.checkDrag();
				}
				break;
			case 1:
				if(InputState::getInstance()->left_mouse_down == false){
					d->placing_locked=false;
					
				} else if(d->placing_locked ==false){
					d->placing_locked = true;
					
					/*preview.emplace_back(
							InputState::getInstance()->mouse_x-InputState::getInstance()->selfOX,
							InputState::getInstance()->mouse_y-InputState::getInstance()->selfOY
						);*/
					
					CustomElectricalComponent* newC = new CustomElectricalComponent(*selectedElectrical);
					
					newC->position.x = InputState::getInstance()->mouse_x-InputState::getInstance()->screenoffset_x-InputState::getInstance()->selfOX;
					newC->position.y = InputState::getInstance()->mouse_y-InputState::getInstance()->screenoffset_y-InputState::getInstance()->selfOY;
					newC->selfComp =ComponentFactory::create(electronics,*newC);
					
					if(newC->selfComp !=nullptr){
						newC->selfComp->setSerializedRef(newC);
						sceneSaveable.components.push_back(newC);
					}
					
				}
				
				break;
			case 2:
				d->needsPortHighlight = true;
				if(d->screen_updated == true){
					electronics.checkDrag();
					
				}
				
				//std::cout << d->phasesWiring << std::endl;
				
				switch(d->phasesWiring){
					case 0: //For1
						
						if(InputState::getInstance()->dragged2DElement != nullptr){
							auto* ec = dynamic_cast<ElectricalComponent*>(
								InputState::getInstance()->dragged2DElement
							);

							if (ec) {
								d->forWire1 = ec;
								d->p1 = ec->getNearestPort(InputState::getInstance()->mouse_x,InputState::getInstance()->mouse_y);
								d->phasesWiring = 1;
							}
						}
						break;
					case 1: //For2
						if (InputState::getInstance()->dragged2DElement && InputState::getInstance()->dragged2DElement != d->forWire1){
							auto* ec = dynamic_cast<ElectricalComponent*>(
								InputState::getInstance()->dragged2DElement
							);

							if (ec) {
								d->forWire2 = ec;
								d->p2 = ec->getNearestPort(InputState::getInstance()->mouse_x,InputState::getInstance()->mouse_y);
								d->phasesWiring = 2;
							}
						}
						break;
					case 2:{
						auto* ec1 = dynamic_cast<ElectricalComponent*>(d->forWire1);
						auto* ec2 = dynamic_cast<ElectricalComponent*>(d->forWire2);

						if (!ec1 || !ec2){
							d->phasesWiring = 3;
							d->forWire1=nullptr;
							d->forWire2=nullptr;
							
							d->p1 = nullptr;
							d->p2 = nullptr;
							break;
						}

						if (d->p1 && d->p2) {
							electronics.connectPort(d->p1, d->p2);
						}

						d->phasesWiring = 3;
						d->forWire1=nullptr;
						d->forWire2=nullptr;
						d->p1 = nullptr;
						d->p2 = nullptr;
						
						
						break;
					}
					case 3:
						if(InputState::getInstance()->left_mouse_down == false){
							d->phasesWiring=0;
							InputState::getInstance()->dragged2DElement=nullptr;
						}
						break;
				}
				
				break;
			case 3:
				
				if(InputState::getInstance()->left_mouse_down == false){
					d->placing_locked=false;
				
				} else if(d->placing_locked ==false){
					d->placing_locked = true;
					
					electronics.tryRotate(d->rotationValue);
					
				}
					
				break;
			case 4:
				
				if(InputState::getInstance()->left_mouse_down == false){
					d->placing_locked=false;
				
				} else if(d->placing_locked ==false){
					d->placing_locked = true;
					
					electronics.tryInvert();
					
				}
					
				break;
		}
	}
}
