#include "PCB_menu.hpp"


PCBPage::PCBPage(){
	board = new Board();
}

PCBPage::~PCBPage(){
	delete board;
	board = nullptr;
}

void PCBPage::initialize(){
	
}

void PCBPage::loadTextureForComponent(const char* filepath){

}


void PCBPage::drawGUI(ImVec4& clear_color,float frate){
	if(d == nullptr){
		return;
	}
	
	//board
	
	if(d->draw_list != nullptr){
		if(board != nullptr){
			board->draw(d->show_overlay_text,d->draw_list,InputState::getInstance()->screenoffset_x,InputState::getInstance()->screenoffset_y,d->cell_size);
			
			if (d->currentCutout.size() >= 1 && d->selectedToolId == 1) {
				d->screen_updated = true;
				std::vector<ImVec2> preview;
				preview.reserve(d->currentCutout.size() + 1);

				for (const ImVec2& p : d->currentCutout) {
					preview.emplace_back(p.x + InputState::getInstance()->screenoffset_x, p.y + InputState::getInstance()->screenoffset_y);
				}

				preview.emplace_back(
					InputState::getInstance()->mouse_x-InputState::getInstance()->selfOX,
					InputState::getInstance()->mouse_y-InputState::getInstance()->selfOY
				);
				

				d->draw_list->AddPolyline(
					preview.data(),
					preview.size(),
					PCB_HIGHLIGHT_COLOR,
					false,
					2.0f
				);
			}
			
			if (currentTrace.points.size() >= 1 && board) {
				std::vector<ImVec2> preview;
				preview.reserve(currentTrace.points.size() + 1);

				// Add all existing points
				for (const ImVec2& p : currentTrace.points) {
					preview.emplace_back(
						p.x + InputState::getInstance()->screenoffset_x,
						p.y + InputState::getInstance()->screenoffset_y
					);
				}

				preview.emplace_back(
					InputState::getInstance()->mouse_x-InputState::getInstance()->selfOX,
					InputState::getInstance()->mouse_y-InputState::getInstance()->selfOY
				);
				
				ImU32 col = (currentTrace.layer == 1) ? WIRE_COLOR_LAYER2: WIRE_COLOR_LAYER1;

				// Draw the polyline
				d->draw_list->AddPolyline(preview.data(),preview.size(),col,false,(float)currentTrace.width_mm);
			}
		}
	}
	
	
	{
		//static float f = 0.0f;
		//static int counter = 0;
		ImGui::SetNextWindowPos(ImVec2(0, 0));
		ImGui::Begin("PCB editor",nullptr,ImGuiWindowFlags_AlwaysAutoResize);

		ImGui::Text("Click to the tools to select them, drag or drop elements.");
		ImGui::Separator();
		ImGui::Text("Information:");
		ImGui::Checkbox("Show schematic overlay stats", &d->show_overlay_text);
		
		if(ImGui::Checkbox("Snap to grid", &d->snap_to_grid)){
			if(d->snap_to_grid == true){
				InputState::getInstance()->snap_grid_size = d->cell_size;
			} else {
				InputState::getInstance()->snap_grid_size = 1;
			}
		}
		if (ImGui::Button("Show components")){
			show_comp_window = true;
		}
		ImGui::Separator();
		ImGui::Text("Vanity tools:");
		
		

		ImGui::ColorEdit3("clear color", (float*)&clear_color);
		ImGui::Separator();
		
		// Board size controls
		ImGui::Text("Board size (mm)");

		static double board_width  = 0.0;
		static double board_height = 0.0;

		// Initialize once from board
		if (board_width == 0.0 && board_height == 0.0 && board) {
			board_width  = board->size.x;
			board_height = board->size.y;
		}

		if (ImGui::InputDouble("Width",  &board_width,  10.0, 10000.0, "%.2f") | ImGui::InputDouble("Height", &board_height, 10.0, 10000.0, "%.2f")){
			if (board) {
				board->size.x = (float)board_width;
				board->size.y = (float)board_height;
			}
		}
		
		ImGui::Separator();
		
		ImGui::Text("General tools:");

		ImGui::Separator();
		if (ImGui::Button("Look around")) {
			d->selectedToolId =0;
		}
		ImGui::Separator();
		if (ImGui::Button("Make cutouts")) {
			d->selectedToolId =1;
			d->currentCutout.clear();
			d->placingCutout=false;
		}
		ImGui::Separator();
		if (ImGui::Button("Select and delete")) {
			d->selectedToolId =2;
			InputState::getInstance()->dragMode = false;
		}
		ImGui::Separator();
		if (ImGui::Button("Drag elements")) {
			d->selectedToolId =2;
			InputState::getInstance()->dragMode = true;
		}
		ImGui::Separator();
		if (ImGui::Button("Place trace")) {
			d->selectedToolId =3;
			placingTrace = false;
			traceStart = true;
		}
		ImGui::Text("Trace settings:");

		ImGui::PushItemWidth(100);
		ImGui::InputDouble("Width (mm)", &_width_mm, 0.1, 1.0, "%.2f");
		ImGui::PopItemWidth();

		ImGui::Combo("Layer", &_layer, layers, IM_ARRAYSIZE(layers));

		ImGui::Separator();
		if (ImGui::Button("Place via")) {
			d->selectedToolId =4;
		}
		ImGui::PushItemWidth(100);
		ImGui::InputDouble("Drill (mil)", &drill, 1.0, 10.0, "%.1f");
		ImGui::InputDouble("Diameter (mil)", &diam, 1.0, 10.0, "%.1f");
		ImGui::PopItemWidth();
		
		ImGui::Separator();
		ImGui::Text("Save / load or export:");

		static std::string save_name;
		if (ImGui::Button("Save to:")) {
			if(board != nullptr){
				//saveBoardToFile(const Board& board, const std::string& filename)
				board_loader.saveBoardToFile(*board,save_name+PCB_FILE_EXTENSION);
			}
			
		}
		ImGui::InputText("Save location", &save_name);
		ImGui::Separator();
		static std::string load_name;
		
		if (ImGui::Button("Load from:")) {
			delete board;
			board = nullptr;
			
			Board* n = new Board();
			if(board_loader.loadBoardFromFile(*n, load_name+PCB_FILE_EXTENSION) == false){
				//TODO error.
			}
			
			board = n;
			n=nullptr;
			//sceneSaveable.loadFrom(load_name+DCF_FILE_EXTENSION);
		}
		ImGui::InputText("Load location", &load_name);
		ImGui::Separator();

		ImGui::Text("Application average %.3f ms/frame (%.1f FPS)", 1000.0f / frate, frate);
		ImGui::End();
	}
	
	
	if (show_comp_window){
		ImGui::SetNextWindowFocus();
		ImGui::Begin("Electrical schematic components", &show_comp_window,ImGuiWindowFlags_AlwaysAutoResize);
		
		std::string totalList = "\nNets:\n";
		for(size_t i=0;i<sim->netAmount();i++){
			totalList+= sim->getNet(i)->getName() +": Voltage:" + std::to_string(sim->getNet(i)->voltage)+"V ("+std::to_string(i)+")\n";
		}
		
		totalList+= "\nComponents:\n";
		for(size_t i=0;i<sim->componentAmount();i++){
			totalList+= sim->getComponent(i)->getName() +" ("+std::to_string(i)+")\n";
		}
	
		ImGui::Text("Components, wires and nets: %s",totalList.c_str());
		if (ImGui::Button("Close")){
			show_comp_window = false;
		}
		ImGui::End();
	}
	
	if(InputState::getInstance()->dragMode == false &&InputState::getInstance()->dragging == true && InputState::getInstance()->dragged2DElement){
		ImGui::SetNextWindowFocus();
		ImGui::Begin("Selected component",nullptr,ImGuiWindowFlags_AlwaysAutoResize);
		
		if (ImGui::Button("Delete component")){
			InputState::getInstance()->dragging = false;
			board->checkDelete(InputState::getInstance()->dragged2DElement);
			InputState::getInstance()->dragged2DElement = nullptr;
		}
		if (ImGui::Button("Deselect")){
			InputState::getInstance()->dragging = false;
			InputState::getInstance()->dragged2DElement = nullptr;
		}
		ImGui::End();
	}
}

void PCBPage::handleInteractions(){
	if (!ImGui::IsWindowHovered(ImGuiHoveredFlags_AnyWindow) && !ImGui::IsAnyItemHovered()){
		switch(d->selectedToolId){
			case 0: //ZOOM / PAN
				/**/
				break;
			case 1: // CUTOUT TOOL
				{
					if(board == nullptr){
						return;
					}

					ImVec2 mousePos(
						InputState::getInstance()->mouse_x -InputState::getInstance()->screenoffset_x-InputState::getInstance()->selfOX,
						InputState::getInstance()->mouse_y -InputState::getInstance()->screenoffset_y-InputState::getInstance()->selfOY
					);

					if (InputState::getInstance()->left_mouse_down) {
						if (!d->placingCutout) {
							d->placingCutout = true;
							d->currentCutout.push_back(mousePos);
						}
					} else {
						d->placingCutout = false;
					}

					if (InputState::getInstance()->right_mouse_down) {
						if (d->currentCutout.size() >= 3) {
							Cutout c;
							c.polygon = d->currentCutout;
							board->cutouts.push_back(c);
							d->currentCutout.clear();
						}

						d->currentCutout.clear();
						d->placingCutout = false;
					}

					break;
				}
			case 2: //ZOOM / PAN 
				if(d->screen_updated == true && board != nullptr){
					board->update(InputState::getInstance()->screenoffset_x,InputState::getInstance()->screenoffset_y);
					board->checkDrag(); 
				}
				break;
			
			case 3: { //TRACE
				if (!board) return;

				auto* input = InputState::getInstance();

				ImVec2 mousePos(
					InputState::getInstance()->mouse_x -InputState::getInstance()->screenoffset_x-InputState::getInstance()->selfOX,
					InputState::getInstance()->mouse_y -InputState::getInstance()->screenoffset_y-InputState::getInstance()->selfOY
				);

				if (input->left_mouse_down && placingTrace == false) {
					placingTrace = true;
					if (traceStart == true) {
						traceStart=false;

						Trace newTrace;
						newTrace.layer = _layer;
						newTrace.width_mm = _width_mm;
						newTrace.points.push_back(mousePos);
						currentTrace = newTrace;
						
					} else {
						currentTrace.points.push_back(mousePos);
					}
				} else {
					placingTrace = false;
					
				}

				if (input->right_mouse_down) {
					if (currentTrace.points.size() >= 2) {
						board->traces.push_back(currentTrace);
					}

					currentTrace.points.clear();
					placingTrace = false;
					traceStart = true;
				}

				break;
			}
			case 4:
				if(board == nullptr){
					return;
				}
				
				if(InputState::getInstance()->left_mouse_down == false){
					d->placing_locked=false;
				
				} else if(d->placing_locked ==false){
					d->placing_locked = true;
					
					auto* input = InputState::getInstance();
					
					ImVec2 viaPos(
						InputState::getInstance()->mouse_x -InputState::getInstance()->screenoffset_x-InputState::getInstance()->selfOX,
						InputState::getInstance()->mouse_y -InputState::getInstance()->screenoffset_y-InputState::getInstance()->selfOY
					);

					Via newVia;
					newVia.setPosition(viaPos.x, viaPos.y);
					newVia.update(input->screenoffset_x, input->screenoffset_y);
					
					newVia.drill_mm=drill;
					newVia.diameter_mm=diam;

					board->vias.push_back(newVia);
					
				}
					
				break;
		}
	}
}
		

