#ifndef ELECTRICAL_SERIALIZABLE_HPP
#define ELECTRICAL_SERIALIZABLE_HPP

class ElectricalComponent;

#include <vector>
#include <string>
#include <unordered_map>
#include "imgui.h"
#include "imgui_impl_glfw.h"
#include "imgui_impl_opengl3.h"

struct PortConnection {
    int portIndex;        // index of the port in this component
    int otherComponentId; // index/id of the connected component
    int otherPortIndex;   // index of the port in the other component
};

enum class ComponentType {
    EGND,
    EResistor,
	EVoltageSource,
	ECapacitor,
	ECurrentSource,
	EDiode,
	ELogicalPin,
	ENPNTransistor,
	ENullPort,
	EOpAmp,
	
	DOrGate,
	DAndGate,
	DInputBit,
	DOutputBit,
	DXorGate,
	DNandGate,
	DInvertGate
};

class CustomElectricalComponent {
	private:
	
	public:
		ElectricalComponent* selfComp = nullptr;
	
		ComponentType type;

		ImVec2 position;
		
		double rotation=0.0;
		
		int id = -1;
		
		std::string texture;

		std::vector<ImVec2> pins; //The port footprints

		// generic extra parameters
		std::unordered_map<std::string, float> floats;
		std::unordered_map<std::string, int> ints;
		std::unordered_map<std::string, std::string> strings;
		
		std::vector<PortConnection> connections;
		
		std::string importedName;
		
		CustomElectricalComponent() {
			
		};

		CustomElectricalComponent(const CustomElectricalComponent& other): selfComp(nullptr),
			  type(other.type),
			  position(other.position),
			  rotation(other.rotation),
			  id(other.id),
			  texture(other.texture),
			  pins(other.pins),
			  floats(other.floats),
			  ints(other.ints),
			  strings(other.strings),
			  connections(other.connections),
			  importedName(other.importedName)
		{
			
		}
};

#endif