#ifndef BOARD_LOADER_HPP
#define BOARD_LOADER_HPP

#include "electronic_module_saving.hpp"

#include "../world_pieces/PCB/trace.hpp"
#include "../world_pieces/PCB/via.hpp"
#include "../world_pieces/PCB/cutout.hpp"
#include "../world_pieces/PCB/board.hpp"

void to_json(json& j, const Trace& t);

void from_json(const json& j, Trace& t);

void to_json(json& j, const Via& v);

void from_json(const json& j, Via& v);

void to_json(json& j, const Cutout& c);

void from_json(const json& j, Cutout& c);

void to_json(json& j, const Board& b);
void from_json(const json& j, Board& b);

class BoardLoader{
	private:
	
	public:
		void saveBoardToFile(const Board& board, const std::string& filename);

		bool loadBoardFromFile(Board& board, const std::string& filename);
};

#endif