#include "board_loader.hpp"

void to_json(json& j, const Trace& t) {
    j = json{
        {"width_mm", t.width_mm},
        {"layer", t.layer},
        {"points", t.points} // ImVec2 is already serializable
    };
}

void from_json(const json& j, Trace& t) {
    j.at("width_mm").get_to(t.width_mm);
    j.at("layer").get_to(t.layer);
    j.at("points").get_to(t.points);
}

void to_json(json& j, const Via& v) {
    j = json{
        {"position", v.position},
        {"drill_mm", v.drill_mm},
        {"diameter_mm", v.diameter_mm}
    };
}

void from_json(const json& j, Via& v) {
    j.at("position").get_to(v.position);
    j.at("drill_mm").get_to(v.drill_mm);
    j.at("diameter_mm").get_to(v.diameter_mm);
}

void to_json(json& j, const Cutout& c) {
    j = json{
        {"polygon", c.polygon}
    };
}

void from_json(const json& j, Cutout& c) {
    j.at("polygon").get_to(c.polygon);
}

void to_json(json& j, const Board& b) {
    j = json{
        {"position", b.position},
        {"size", b.size},
        {"traces", b.traces},
        {"vias", b.vias},
        {"cutouts", b.cutouts}
    };
}

void from_json(const json& j, Board& b) {
    j.at("position").get_to(b.position);
    j.at("size").get_to(b.size);
    j.at("traces").get_to(b.traces);
    j.at("vias").get_to(b.vias);
    j.at("cutouts").get_to(b.cutouts);
}

void BoardLoader::saveBoardToFile(const Board& board, const std::string& filename) {
	json j = board;
	std::ofstream file(filename);
	if(file.is_open()) {
		file << j.dump(4); // pretty print with 4 spaces
		file.close();
	}
}

bool BoardLoader::loadBoardFromFile(Board& board, const std::string& filename) {
	std::ifstream file(filename);
	if(!file.is_open()) return false;

	json j;
	file >> j;
	file.close();

	try {
		board = j.get<Board>();
	} catch (const json::exception& e) {
		std::cerr << "Error loading board: " << e.what() << std::endl;
		return false;
	}
	return true;
}
