#ifndef CNTRL_WINDOW_HPP
#define CNTRL_WINDOW_HPP

#include "electronics_visual_model.hpp"

#include <deque>
#include <iterator>
#include <iostream>
#include <cassert>

#include "utils.hpp"
#include "input_state.hpp"

#include "misc/cpp/imgui_stdlib.h"

#include "file_io/electronic_module_saving.hpp"

#include "menus/PCB_menu.hpp"
#include "menus/electronics_menu.hpp"
#include "menus/digital_menu.hpp"

#include "control_data.hpp"

class ControlWindow: public RenderWindow<ControlWindow>{
	private:
		double offset_x=0;
		double offset_y=0;
		
		
		int cell_count_X=0;
		int cell_count_Y=0;
		
		int dir_x = 0;
		int dir_y = 0;
		
		LogicalPage* page = nullptr;
		
		ControlData* d = nullptr;
		
		const ImVec2 window_size = ImVec2(300, 200); //Right menu
		
		int switchedType=0;
	public:
	
		/*void loadTextureForComponent(const char* filepath){
			#ifndef DIGITAL
				//Electronics
				std::string fullPath = std::string(GRAPHICS_PATH) + GRAPHICS_ELECTRONICS_PATH + filepath;
			#else
				//Digital
				std::string fullPath = std::string(GRAPHICS_PATH) + GRAPHICS_DIGITAL_PATH + filepath;
			#endif
			
			
			int TtextureWidth;
			int TtextureHeight;
			GLuint opengl_texture = loadTexture(fullPath.c_str(),TtextureWidth,TtextureHeight);
			ImTextureID tex_id = (ImTextureID)opengl_texture;
			componentTextures.emplace_back(tex_id);
		}*/
		
		static void scroll_callback(GLFWwindow* window, double xoffset, double yoffset) {
			InputState::getInstance()->scroll_x = xoffset;
			InputState::getInstance()->scroll_y = yoffset;
		}

		ControlWindow(int _window_width, int _window_height, const char* _window_title);
		~ControlWindow();
		
		void init();
		
		void switchTo(int windowId);
		
		void handleMovement(float delta_time);
		
		//rgba format for color
		void draw_cell(int off_x, int off_y, int x, int y, ImVec4 color,bool filled);
		
		void tick();
};

#endif