#include "./tonemapping.hpp"

Color ReinhardMapping(const Color& c){
	Color mapped;
	mapped.r = c.r / (1.0 + c.r);
	mapped.g = c.g / (1.0 + c.g);
	mapped.b = c.b / (1.0 + c.b);
	
	return mapped;
}

Color LinearMapping(const Color& c){
	Color mapped;
	mapped.r = std::min(c.r,1.0);
	mapped.g = std::min(c.g,1.0);
	mapped.b = std::min(c.b,1.0);
	
	return mapped;
}

Color FilmicMapping(const Color& c, double exposure){
	Color mapped;
	mapped.r = 1.0 - std::pow(e,-c.r*exposure);
	mapped.g = 1.0 - std::pow(e,-c.g*exposure);
	mapped.b = 1.0 - std::pow(e,-c.b*exposure);
	
	return mapped;
}