#ifndef SCENE_HPP
#define SCENE_HPP

#include "./image.hpp"
#include "./camera.hpp"
#include "./shape.hpp"
#include "./light.hpp"
#include "./utils.hpp"
#include "./shaders/lambert.hpp"
#include "./shaders/phong.hpp"

class Scene{
	private:
		double exposure=0.4;
		double ambient_light_strength=4.0;
	public:
	
		void setExposure(double d);
		
		void setAmbientLightStrength(double d);
		
		double getExposure() const;
		
		double getAmbientLightStrength() const;
		
		ShapeSet contents;
		
		Scene();
		
		void add(Shape* elem);
		
		void rayTrace(Image& image, Camera* camera);
		
};

#endif