#ifndef MATH_VEC_HPP
#define MATH_VEC_HPP

#include <cmath>

//TODO optimize, memoize length of vectors

inline double square(double num){
	return num*num;
}

#define squared square

inline float square(float num){
	return num*num;
}

class Vec3{
	private:
		
	public:
		double x;
		double y;
		double z;
		
		Vec3(); //Vector with length 1 in the UP direction
		Vec3(const Vec3& v);
		Vec3(double _x, double _y, double _z);
		Vec3(double val);
		
		virtual ~Vec3();
		
		double length_squared() const;
		double length() const;
		
		double normalize();
		Vec3 normalized();
		
		Vec3& operator=(const Vec3& v);
		Vec3& operator+=(const Vec3& v);
		Vec3& operator-=(const Vec3& v);
		
		Vec3& operator*=(const Vec3& v);
		
		Vec3& operator/=(const Vec3& v);
		
		Vec3& operator*=(double f);
		
		Vec3& operator/=(double f);
		
		Vec3 operator-() const;
};

double dot(Vec3 v1, Vec3 v2);
Vec3 cross(Vec3 v1, Vec3 v2);

inline Vec3 operator+(const Vec3& v1, const Vec3& v2){
	return Vec3(v1.x+v2.x,v1.y+v2.y,v1.z+v2.z);
}

inline Vec3 operator-(const Vec3& v1, const Vec3& v2){
	return Vec3(v1.x-v2.x,v1.y-v2.y,v1.z-v2.z);
}

inline Vec3 operator*(const Vec3& v1, const Vec3& v2){
	return Vec3(v1.x*v2.x,v1.y*v2.y,v1.z*v2.z);
}
inline Vec3 operator*(const Vec3& v1, double d){
	return Vec3(v1.x*d,v1.y*d,v1.z*d);
}
inline Vec3 operator*(double d,const Vec3& v1){
	return Vec3(v1.x*d,v1.y*d,v1.z*d);
}
inline Vec3 operator/(const Vec3& v1, const Vec3& v2){
	return Vec3(v1.x/v2.x,v1.y/v2.y,v1.z/v2.z);
}
inline Vec3 operator/(const Vec3& v1, double d){
	return Vec3(v1.x/d,v1.y/d,v1.z/d);
}
inline Vec3 operator/(double d,const Vec3& v1){
	return Vec3(d/v1.x,d/v1.y,d/v1.z);
}

typedef Vec3 Point;
typedef Vec3 Vector;

class Vec2{
	private:
	
	public:
		double x;
		double y;
		
		Vec2(); //Vector with length 0
		Vec2(const Vec2& v);
		Vec2(double _x, double _y);
		Vec2(double val);
		
		virtual ~Vec2();
		
		Vec2& operator=(const Vec2& v);
};

#endif