#include "./math_vec.hpp"

Vec3::Vec3(){
	x=0.0;
	y=1.0;
	z=0.0;
}

Vec3::Vec3(const Vec3& v){
	x = v.x;
	y = v.y;
	z = v.z;
}
Vec3::Vec3(double _x, double _y, double _z){
	x = _x;
	y = _y;
	z = _z;
}
Vec3::Vec3(double val){
	x = val;
	y = val;
	z = val;
}

Vec3::~Vec3(){
	
}

double Vec3::length_squared() const{
	return square(x)+square(y)+square(z);
}
double Vec3::length() const{
	return std::sqrt(length_squared());
}

double Vec3::normalize(){
	float len = length();
	*this /= len;
	
	return len;
}
Vec3 Vec3::normalized(){
	Vec3 v(*this);
	v.normalize();
	return v;
}

double dot(Vec3 v1, Vec3 v2){
	return v1.x*v2.x + v1.y*v2.y + v1.z*v2.z;
}

Vec3 cross(Vec3 v1, Vec3 v2){
	return Vec3(v1.y*v2.z-v1.z*v2.y,v1.z*v2.x-v1.x*v2.z,v1.x*v2.y - v1.y * v2.x);
}

Vec3& Vec3::operator=(const Vec3& v){
	x = v.x;
	y = v.y;
	z = v.z;
	
	return *this;
}

Vec3& Vec3::operator+=(const Vec3& v){
	x += v.x;
	y += v.y;
	z += v.z;
	
	return *this;
}

Vec3& Vec3::operator-=(const Vec3& v){
	x -= v.x;
	y -= v.y;
	z -= v.z;
	
	return *this;
}

Vec3& Vec3::operator*=(const Vec3& v){
	x *= v.x;
	y *= v.y;
	z *= v.z;
	
	return *this;
}

Vec3& Vec3::operator/=(const Vec3& v){
	x /= v.x;
	y /= v.y;
	z /= v.z;
	
	return *this;
}

Vec3& Vec3::operator*=(double f){
	x *= f;
	y *= f;
	z *= f;
	
	return *this;
}

Vec3& Vec3::operator/=(double f){
	x /= f;
	y /= f;
	z /= f;
	
	return *this;
}

Vec3 Vec3::operator-() const{
	return Vec3(-x,-y,-z);
}

//VEC2

Vec2::Vec2(){
	x=0.0;
	y=0.0;
}

Vec2::Vec2(const Vec2& v){
	x = v.x;
	y = v.y;
}
Vec2::Vec2(double _x, double _y){
	x = _x;
	y = _y;
}
Vec2::Vec2(double val){
	x = val;
	y = val;
}

Vec2::~Vec2(){
	
}

Vec2& Vec2::operator=(const Vec2& v){
	x = v.x;
	y = v.y;
	
	return *this;
}
