#ifndef MATH_RAY_HPP
#define MATH_RAY_HPP

#include "./math_vec.hpp"
#include "./color.hpp"
#include <cmath>

//Prevent self intersection, minimum from start point.
#define RAY_T_MIN 0.0001f

//Max. distance from start point: infinite distance.
#define RAY_T_MAX 1.0e30f

class Ray{
	private:
	
	public:
		Point origin;
		Vec3 direction;
		double tMax;
		
		Ray();
		Ray(const Ray& r);
		Ray(const Point& _origin, const Vec3& _direction, double _tMax = RAY_T_MAX);
		
		virtual ~Ray();
		
		Ray& operator=(const Ray& r);
		
		Point calculate(double t) const;
	
};

class Shape;

class Intersection{
	private:
	
	public:
		Ray ray;
		double t;
		Shape* pShape;
		Color color;
		Vec3 normal;
		
		Intersection();
		Intersection(const Intersection& i);
		Intersection(const Ray& _ray);
		
		virtual ~Intersection();
		
		Intersection& operator=(const Intersection& i);
		
		bool intersected() const;
		Point position() const;
};

#endif