//Credits: Light Classes from HillbertCode, raytrace and lambert shading logic implemented by me.

#include "./math_vec.hpp"
#include <iostream>

#include <QtCore/QCoreApplication>

#include "./image.hpp"
#include "./camera.hpp"
#include "./shape.hpp"
#include "./light.hpp"
#include "./utils.hpp"
#include "./scene.hpp"
#include "./tonemapping.hpp"

#define EXAMPLE_SCENE_3


int main(){
	int width = 1920;
	int height = 1080;
	
	Image image(width,height);
	
	PerspectiveCamera camera(Point(-5.0,1.0,0.0), Vec3(0.0,1.0,0.0), Vec3(), PI/4, width/height);
	
	Scene scene;
	
	Plane floor(Point(0.0,0.0,0.0), Vec3(0.0,1.0,0.0), Color(1.0,0.5,0.5));
	scene.add(&floor);
	
	Plane wall1(Point(0.5,0.0,0.0), Vec3(-1.0,0.0,0.0), Color(1.0,0.7,0.7));
	scene.add(&wall1);
	
	#ifdef EXAMPLE_SCENE_1
	
		Sphere sphere(Point(0.0,1.0,0.0),1.0, Color(1.0,0.1,0.1));
		scene.add(&sphere);
		
		ShapeLight light(new Sphere(Point(-1.0,2.0,0.0),0.1, Color(0.0,0.0,1.0)),Color(0.0,0.0,1.0),10.0);
		scene.add(&light);
		
		ShapeLight light2(new Sphere(Point(-1.0,2.0,2.0),0.2, Color(0.0,1.0,0.0)),Color(0.0,1.0,0.0),9.0);
		scene.add(&light2);
	
	#endif
	
	#ifdef EXAMPLE_SCENE_2
	
		Sphere sphere(Point(0.0,1.0,0.0),1.0, Color(1.0,0.1,0.1));
		scene.add(&sphere);
		
		Sphere sphere2(Point(-0.1,0.8,2.0),0.8, Color(1.0,1.0,0.1));
		scene.add(&sphere2);
		
		Sphere sphere3(Point(0.5,1.0,-1.0),0.7, Color(0.0,0.1,1.0));
		scene.add(&sphere3);
		
		ShapeLight light(new Sphere(Point(-1.0,2.0,0.0),0.1, Color(0.0,4.0,1.0)),Color(1.0,1.0,1.0),15.0);
		scene.add(&light);
	
	#endif
	
	#ifdef EXAMPLE_SCENE_3
	
		Sphere sphere(Point(0.0,1.0,0.0),1.0, Color(1.0,0.1,0.1));
		scene.add(&sphere);
		
		ShapeLight light(new Sphere(Point(-1.0,2.0,0.0),0.1, Color(0.0,0.0,1.0)),Color(0.0,0.0,1.0),10.0);
		scene.add(&light);
		
		ShapeLight light2(new Sphere(Point(-1.0,4.0,2.0),0.2, Color(0.0,1.0,0.0)),Color(0.0,1.0,0.0),9.0);
		scene.add(&light2);
		
		scene.setAmbientLightStrength(1.0);
	
	#endif
	
	scene.rayTrace(image, &camera);
	
	image.saveImage("out.png");
	
	std::cout << "TEST" << std::endl;
	return 0;
}