#ifndef LIGHT_HPP
#define LIGHT_HPP

#include <list>

#include "./math_vec.hpp"
#include "./color.hpp"
#include "./shape.hpp"
#include <cmath>

#define SHADOW_BIAS 0.001

//Global environment light
class Light: public Shape{
	private:
	
	protected:
		Color color;
		double power;
		//Emitter material;
	
	public:
		Light(const Color& color, double power);
		
		virtual ~Light();
		
		virtual bool isLight() const;
		
		virtual Vec3 getPosition() const;
		
		virtual Color emitted() const;
		
		virtual double intersectPdf(const Intersection& isect) = 0;
};

class RectangleLight : public Light{
	public:
		RectangleLight(const Point& pos, const Vec3& side1, const Vec3& side2, const Color& color, double power);

		virtual ~RectangleLight();

		virtual bool intersect(Intersection& intersection);
		virtual bool doesIntersect(const Ray& ray);

		virtual bool sampleSurface(const Point& surfPosition,const Vec3& surfNormal,double u1, double u2, double u3,Point& outPosition,Vec3& outNormal,double& outPdf);
		
		virtual bool isLight() const;

		virtual double intersectPdf(const Intersection& isect);
		
		virtual Vec3 getPosition() const;

	protected:
		Point origin;
		Vec3 side1;
		Vec3 side2;
};

class ShapeLight : public Light{
	public:
		ShapeLight(Shape *pShape, const Color& color, double power);

		virtual ~ShapeLight();

		virtual bool intersect(Intersection& intersection);
		virtual bool doesIntersect(const Ray& ray);

		virtual bool sampleSurface(const Point& surfPosition, const Point& surfNormal, double u1, double u2, double u3, Point& outPosition, Vec3& outNormal, double& outPdf);
		
		virtual bool isLight() const;

		virtual double intersectPdf(const Intersection& isect);
		
		virtual Vec3 getPosition() const;

	protected:
		Shape* pShape;
};
#endif