#ifndef IMAGE_HPP
#define IMAGE_HPP

#include <string>

#include "./color.hpp"

//Greyscale image
class Image{
	
	protected:
		int width;
		int height;
		Color* data;
		
	public:
		Image(int width, int height);
		
		virtual ~Image();
		
		int getWidth() const;
		int getHeight() const;
		
		Color* getPixel(int x, int y);
		
		void saveImage(std::string filename, double exposure=1.0, double gamma=2.2) const;
		
	private:
};

#endif