#include "./color.hpp"

Color::Color(){
	r = 0.0;
	g= 0.0;
	b = 0.0;
}

Color::Color(double l){
	r = l;
	g = l;
	b = l;
}

Color::Color(double _r, double _g, double _b){
	r = _r;
	g = _g;
	b = _b;
}

Color::~Color(){
	
}

void Color::clamp(double min, double max){
	
	r = std::max(min, std::min(max,r));
	g = std::max(min, std::min(max,g));
	b = std::max(min, std::min(max,b));
}

void Color::applyGammaCorrection(double exposure, double gamma){
	r = std::pow(r*exposure,gamma);
	g = std::pow(g*exposure,gamma);
	b = std::pow(b*exposure,gamma);
}

Color& Color::operator=(const Color& c){
	r = c.r;
	g = c.g;
	b = c.b;
	
	return *this;
}

Color& Color::operator+=(const Color& c){
	r += c.r;
	g += c.g;
	b += c.b;
	
	return *this;
}

Color& Color::operator*=(const Color& c){
	r *= c.r;
	g *= c.g;
	b *= c.b;
	
	return *this;
}

Color& Color::operator*=(double f){
	r *= f;
	g *= f;
	b *= f;
	
	return *this;
}
