#include "./camera.hpp"

PerspectiveCamera::PerspectiveCamera(Point origin, Vec3 target, Vec3 upguide, double fov, double aspectRatio): origin(origin){
	
	forward = (target- origin).normalized();
	
	right = cross(forward, upguide).normalized();
	
	up = cross(right,forward);
	
	height = tan(fov);
	width = height* aspectRatio;
}

Ray PerspectiveCamera::makeRay(Vec2 point) const{
	
	Vec3 direction = forward + point.x * width * right + point.y * height * up;
	
	return Ray(origin,direction.normalized());
}
