#ifndef BUS_HPP
#define BUS_HPP

#include <cstdint>
#include <array>
#include <memory>

#include "CPU6502.hpp"
#include "PPU2C02.hpp"
#include "Cartridge.hpp"

class Bus{
	private:
		
		uint32_t nSystemClockCounter = 0;
		
		uint8_t controller_state[2];
		
		uint8_t dma_page = 0x00;
		uint8_t dma_addr = 0x00;
		uint8_t dma_data = 0x00;
		
		bool dma_transfer = false;
		bool dma_dummy = true;
	
	public:
	
		Bus();
		~Bus();
		
		void cpuWrite(uint16_t addr, uint8_t data);
		uint8_t cpuRead(uint16_t addr, bool readOnly = false);
		
		PPU2C02 ppu;
		
		CPU6502 cpu;
		
		std::array<uint8_t,2048> CPUram;
		
		void insertCartridge(const std::shared_ptr<Cartridge>& cartridge);
		
		std::shared_ptr<Cartridge> cart;
		
		uint8_t controller[2]; //Store 2 controller states
		
		
		void reset();
		void clock(); //Perform 1 little tick
};

#endif