/*
 * Decompiled with CFR 0.152.
 */
package hu.afghangoat.events;

import com.hypixel.hytale.component.Archetype;
import com.hypixel.hytale.component.ArchetypeChunk;
import com.hypixel.hytale.component.CommandBuffer;
import com.hypixel.hytale.component.Store;
import com.hypixel.hytale.component.query.Query;
import com.hypixel.hytale.component.system.EntityEventSystem;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.math.vector.Vector3f;
import com.hypixel.hytale.protocol.packets.interface_.Page;
import com.hypixel.hytale.server.core.entity.entities.Player;
import com.hypixel.hytale.server.core.entity.entities.player.pages.PageManager;
import com.hypixel.hytale.server.core.event.events.ecs.BreakBlockEvent;
import com.hypixel.hytale.server.core.inventory.Inventory;
import com.hypixel.hytale.server.core.inventory.ItemStack;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.EntityStore;
import com.hypixel.hytale.server.npc.NPCPlugin;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.nullness.compatqual.NonNullDecl;

public class LuckyBreakEvent
extends EntityEventSystem<EntityStore, BreakBlockEvent> {
    public LuckyBreakEvent() {
        super(BreakBlockEvent.class);
    }

    public static double distance(Vector3d a, Vector3d b) {
        double dx = a.x - b.x;
        double dy = a.y - b.y;
        double dz = a.z - b.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public void spawnEntity(String name, Vector3d position, Vector3f _rotation, World _world, Store<EntityStore> _store, int count) {
        NPCPlugin npcP = NPCPlugin.get();
        int bearRole = npcP.getIndex(name);
        _world.execute(() -> {
            for (int i = 0; i < count; ++i) {
                npcP.spawnEntity(_store, bearRole, position, _rotation, null, null);
            }
        });
    }

    public void addItem(Player player, String item_id, int count, Store<EntityStore> store) {
        if (player != null) {
            PageManager pageManager = player.getPageManager();
            pageManager.setPage(player.getReference(), store, Page.Inventory);
            ItemStack item = new ItemStack(item_id, count);
            Inventory inventory = player.getInventory();
            inventory.getHotbar().addItemStack(item);
        }
    }

    public void handle(int index, @NonNullDecl ArchetypeChunk<EntityStore> archetypeChunk, @NonNullDecl Store<EntityStore> store, @NonNullDecl CommandBuffer<EntityStore> commandBuffer, @NonNullDecl BreakBlockEvent breakBlockEvent) {
        Vector3d blockPosition;
        String bid = breakBlockEvent.getBlockType().getId();
        if (!bid.equals("lucky_block")) {
            return;
        }
        Vector3d destinate = blockPosition = breakBlockEvent.getTargetBlock().toVector3d();
        destinate.y += 1.0;
        Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        World world = ((EntityStore)store.getExternalData()).getWorld();
        List refs = world.getPlayers();
        Player nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (Player player : refs) {
            double dist = LuckyBreakEvent.distance(destinate, player.getPlayerRef().getTransform().getPosition());
            if (!(dist < nearestDist)) continue;
            nearestDist = dist;
            nearest = player;
        }
        Player player = nearest;
        Random rnd = new Random();
        switch (rnd.nextInt(44)) {
            case 0: {
                this.spawnEntity("Bear_Grizzly", destinate, rotation, world, store, 1);
                break;
            }
            case 1: {
                this.spawnEntity("Bear_Grizzly", destinate, rotation, world, store, 10);
                break;
            }
            case 2: {
                this.addItem(player, "lucky_block", 1, store);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.addItem(player, "lucky_block", 4, store);
                break;
            }
            case 5: {
                this.addItem(player, "Ingredient_Bar_Silver", 1, store);
                break;
            }
            case 6: {
                this.addItem(player, "Ingredient_Bar_Gold", 2, store);
                break;
            }
            case 7: {
                this.addItem(player, "Ingredient_Tree_Sap", 50, store);
                break;
            }
            case 8: {
                this.addItem(player, "Ingredient_Bar_Iron", 6, store);
                break;
            }
            case 9: {
                this.addItem(player, "Ingredient_Bar_Bronze", 4, store);
                break;
            }
            case 10: {
                this.addItem(player, "Ingredient_Leather_Dark", 4, store);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.addItem(player, "Potion_Health", 2, store);
                break;
            }
            case 13: {
                this.addItem(player, "Tool_Repair_Kit_Iron", 1, store);
                break;
            }
            case 14: {
                this.addItem(player, "Ingredient_Poop", 64, store);
                break;
            }
            case 15: {
                this.addItem(player, "Wood_Drywood_Planks", 32, store);
                break;
            }
            case 16: {
                this.addItem(player, "Wood_Oak_Trunk", 50, store);
                break;
            }
            case 17: {
                this.addItem(player, "Upgrade_Backpack_1", 1, store);
                break;
            }
            case 18: {
                this.addItem(player, "Rubble_Aqua", 20, store);
                break;
            }
            case 19: {
                this.addItem(player, "Rubble_Ice", 20, store);
                break;
            }
            case 20: {
                this.addItem(player, "Rock_Stone_Brick_Decorative", 20, store);
                break;
            }
            case 21: {
                this.addItem(player, "Rock_Salt", 10, store);
                break;
            }
            case 22: {
                this.addItem(player, "Rock_Gem_Diamond", 2, store);
                break;
            }
            case 23: {
                this.addItem(player, "Rock_Bedrock", 1, store);
                break;
            }
            case 24: {
                this.addItem(player, "Armor_Cloth_Cindercloth_Chest", 1, store);
                break;
            }
            case 25: {
                this.addItem(player, "Armor_Cloth_Cindercloth_Hands", 1, store);
                break;
            }
            case 26: {
                this.addItem(player, "Armor_Cloth_Cindercloth_Head", 1, store);
                break;
            }
            case 27: {
                this.addItem(player, "Armor_Cloth_Cindercloth_Legs", 1, store);
                break;
            }
            case 28: {
                this.spawnEntity("Skeleton_Fighter", destinate, rotation, world, store, 3);
                break;
            }
            case 29: {
                this.spawnEntity("Zombie", destinate, rotation, world, store, 3);
                break;
            }
            case 30: {
                this.spawnEntity("Skeleton_Archmage", destinate, rotation, world, store, 1);
                break;
            }
            case 31: {
                this.spawnEntity("Cactee", destinate, rotation, world, store, 1);
                break;
            }
            case 32: {
                this.spawnEntity("Chick", destinate, rotation, world, store, 3);
                break;
            }
            case 33: {
                this.spawnEntity("Catfish", destinate, rotation, world, store, 3);
                break;
            }
            case 34: {
                this.spawnEntity("Corgi", destinate, rotation, world, store, 1);
                break;
            }
            case 35: {
                this.spawnEntity("Outlander_Marauder", destinate, rotation, world, store, 2);
                break;
            }
            case 36: {
                this.spawnEntity("Snake_Cobra", destinate, rotation, world, store, 3);
                break;
            }
            case 37: {
                this.spawnEntity("Temple_Mithril_Guard", destinate, rotation, world, store, 3);
                break;
            }
            case 38: {
                this.spawnEntity("Bat", destinate, rotation, world, store, 3);
                break;
            }
            case 39: {
                this.spawnEntity("Wolf_Black", destinate, rotation, world, store, 4);
                break;
            }
            case 40: {
                this.addItem(player, "Armor_Bronze_Chest", 1, store);
                break;
            }
            case 41: {
                this.addItem(player, "Armor_Bronze_Hands", 1, store);
                break;
            }
            case 42: {
                this.addItem(player, "Armor_Bronze_Head", 1, store);
                break;
            }
            case 43: {
                this.addItem(player, "Armor_Bronze_Legs", 1, store);
            }
        }
    }

    public Query<EntityStore> getQuery() {
        return Archetype.empty();
    }
}

